/*
 * Decompiled with CFR 0.152.
 */
package com.android.gps.data;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.android.gps.domain.VisitorLogDto;
import com.android.gps.domain.use_case.GetCustomerHasOrderAndInvoice;
import com.android.gps.domain.use_case.InsertOrReplaceVisitorLog;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class VisitorLogRepo
extends AndroidRepository<VisitorLogDto> {
    @Resource
    @Lazy
    private InsertOrReplaceVisitorLog insertOrReplaceVisitorLog;
    @Resource
    @Lazy
    private GetCustomerHasOrderAndInvoice getCustomerHasOrderAndInvoice;

    public VisitorLogRepo(DbConnection dbConnection) {
        super(dbConnection);
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (!settingsLoader.isGetGps()) {
            return null;
        }
        return Paging.PageSqlData.builder().selectSqlStr("SELECT [Id], [RMId], [companyId], [customerCode], [visitorCode], \n CONVERT(NVARCHAR(19), [inDateTime], 120) inDateTime, \n CONVERT(NVARCHAR(19), [outDateTime], 120) outDateTime, [inLat], \n [outLat] ,[inLong], [outLong], [inAddress], [outAddress], [userCodeInc]\n  FROM [RMVisitorGPS]").keyField("id").build();
    }

    @NonNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.VISITOR_LOG;
    }

    protected BaseResponse<GenericResponse> insert(VisitorLogDto item, LoginDto login, TransactionStatus status) throws TncException {
        return this.makeBaseGenericResponse(status, () -> this.insertOrReplaceVisitorLog.invoke(item));
    }

    public BaseResponse<GenericResponse> getCustomerHasOrderAndInvoice(RequestData requestData) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        try {
            GenericResponse result = this.getCustomerHasOrderAndInvoice.invoke(requestData);
            return response.data((Object)result).build();
        }
        catch (TncException e) {
            return response.withError(e.makeAndroidError()).build();
        }
    }

    public BaseResponse<Map<String, Object>> getLabels() {
        String sql = "select id, labelName from RateLabel";
        List data = null;
        try {
            data = this.dbConnection.getJdbcTemplate().queryForList("select id, labelName from RateLabel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseError error = data == null || data.isEmpty() ? new BaseError().setErrorCode(String.valueOf(TncExceptionMessages.NO_LABEL_FOUNDED.getCode())).setMessage(TncExceptionMessages.NO_LABEL_FOUNDED.getMessage()) : null;
        BaseResponse.Builder response = new BaseResponse.Builder();
        if (error != null) {
            response.withError(error);
        } else {
            response.data(data);
        }
        return response.build();
    }
}

